from datetime import datetime

from langchain import PromptTemplate


def _get_year() -> str:
    now = datetime.now()
    return now.strftime("%Y")


search_tool_prompt = PromptTemplate(
    input_variables=["question", "count"],
    partial_variables={"date": _get_year},
    template=(
        "We want to answer the following question: {question} \n"
        "Provide {count} unique keyword searches (one search per line) and year ranges "
        "that will find papers to help answer the question. "
        "Do not use boolean operators. "
        "Make sure not to repeat searches without changing the keywords or year ranges. "
        "Make some searches broad and some narrow. "
        "Use this format: [keyword search], [start year]-[end year]. "
        "where end year is optional. "
        "The current year is {date} \n\n"
        "1."
    ),
)


agent_search_tool_prompt = PromptTemplate(
    input_variables=["question"],
    template=(
        "We want to answer the following question: {question}\n"
        "You have access to a search tool to find papers to help answer the question. "
        "Papers you search for will be saved to a database for later use, "
        "and the search tool will return information about the retrieved papers to see if they are relevant. "
        "Please perform as many searches as needed to find genuinely relevant papers. "
        "Make some searches broad and some narrow. "
    ),
)
